;---------------------------------------------------------------------------
; asMSX v.0.12e - DEMO I: FIXED POINT ARITHMETIC - 8 KB ROM
;---------------------------------------------------------------------------
; Example of sprite movement using fixed point numbers
; asMSX v.0.12e - Eduardo Robsy Petrus [24/08/2004]
;---------------------------------------------------------------------------
; Ghost sprite taken from PACMAN, (c) Namcot, 1980
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; HEADER AND DIRECTIVES
;---------------------------------------------------------------------------
; Assembler directives
        .bios
        .page   2
        .rom
        .start  BEGIN
; Text identifier
        db      "asMSX-DEMO I",1ah
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; VRAM CONSTANTS
;---------------------------------------------------------------------------
; VRAM standard positions
        CHRTBL  equ     0000h
        NAMTBL  equ     1800h
        CLRTBL  equ     2000h
        SPRTBL  equ     3800h
        SPRATR  equ     1b00h
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; MAIN PROGRAM
;---------------------------------------------------------------------------
BEGIN:
; Hide screen
        call    DISSCR
; Set COLOR 15,0,0
        ld      hl,0f3e9h
        ld      [hl],15
        inc     hl
        ld      [hl],0
        inc     hl
        ld      [hl],0
; SCREEN 2
        call    INIGRP
; SCREEN ,2
        ld      bc,0e201h
        call    WRTVDP
; Erase background
        ld      hl,NAMTBL
        ld      bc,768
        xor     a
        call    FILVRM
; Define font for bank I
        ld      hl,FONT
        ld      de,CHRTBL+32*8
        ld      bc,64*8
        call    LDIRVM
; Alternate font for bank I
        ld      hl,FONT+33*8
        ld      de,CHRTBL+97*8
        ld      bc,31*8
        call    LDIRVM
; Set color for font on bank I - blue
        ld      de,CLRTBL+32*8
        ld      hl,CLR_BLUE
        ld      b,64
        call    COPY_BLOCK
; Define color for alternate font  - grey
        ld      de,CLRTBL+97*8
        ld      hl,CLR_GREY
        ld      b,31
        call    COPY_BLOCK
; Print some texts
; LOCATE 0,0: PRINT "ASMSX V.0.12e: demo i"
        ld      hl,TXT_ASMSX
        ld      de,NAMTBL+2*32+6
        ld      bc,21
        call    LDIRVM
; LOCATE 2,2: PRINT "FIXED POINT ARITHMETIC"
        ld      hl,TXT_FIXED
        ld      de,NAMTBL+32*4+4
        ld      bc,22
        call    LDIRVM
; Define sprites
        ld      hl,SPR_GHOST
        ld      de,SPRTBL
        ld      bc,64
        call    LDIRVM
; Start position - OTOBOKE
        ld      hl,fix(80.0)
        ld      [POSITION],hl
        ld      hl,fix(0.0)
        ld      [SPEED],hl
        ld      hl,fix(0.25)
        ld      [ACCELERATION],hl
; Start position - OTHER
        xor     a
        ld      [HORIZONTAL],a
; Define sprite
        ld      hl,ATR_INITIAL
        ld      de,SPRITES
        ld      bc,32
        ldir
        ei
; Restore screen
        call    ENASCR
; Main loop
LOOP:
; Move first ghost
        ld      hl,[ACCELERATION]
        ex      de,hl
        ld      hl,[SPEED]
        add     hl,de
        ld      [SPEED],hl
        ex      de,hl
        ld      hl,[POSITION]
        add     hl,de
        ld      [POSITION],hl
; Check rebound
        ld      a,170
        cp      h
        jr      nc,@@READY
; Do rebound
        ld      hl,fix(170.0)
        ld      [POSITION],hl
        ld      hl,[SPEED]
        ex      de,hl
        ld      hl,0000h
        sbc     hl,de
        ld      [SPEED],hl
@@READY:
; Define vertical position OTOBOKE
        ld      hl,[POSITION]
        ld      a,h
        ld      [SPRITES],a
        ld      [SPRITES+4],a
; Define horizontal position OTOBOKE
        ld      hl,SPRITES+1
        dec     [hl]
        dec     [hl]
        ld      hl,SPRITES+5
        dec     [hl]
        dec     [hl]
; Move second ghost
        ld      a,[HORIZONTAL]
        inc     a
        ld      [HORIZONTAL],a
        and     63
        ld      c,a
        ld      b,0
        push    bc
        ld      hl,SIN_TABLE
        add     hl,bc
        ld      b,[hl]
        ld      a,[HORIZONTAL]
        add     a,b
        ld      [SPRITES+9],a
        ld      [SPRITES+13],a
        pop     bc
        ld      hl,COS_TABLE
        add     hl,bc
        ld      a,[hl]
        add     34
        ld      [SPRITES+8],a
        ld      [SPRITES+12],a
; Move third ghost
        ld      a,[HORIZONTAL]
        add     a
        ld      b,a
        ld      a,64
        sub     b
        ld      [SPRITES+17],a
        ld      [SPRITES+21],a
        ld      a,[HORIZONTAL]
        and     63
        ld      c,a
        ld      b,0
        ld      hl,COS_TABLE
        add     hl,bc
        ld      a,[hl]
        sra     a
        add     40
        ld      [SPRITES+16],a
        ld      [SPRITES+20],a
; Move fourth and last ghost
        ld      a,[HORIZONTAL]
        sub     64
        ld      [SPRITES+25],a
        ld      [SPRITES+29],a
        ld      a,[HORIZONTAL]
        add     a
        and     63
        ld      c,a
        ld      b,0
        ld      hl,SIN_TABLE
        add     hl,bc
        ld      a,[hl]
        add     100
        ld      [SPRITES+24],a
        ld      [SPRITES+28],a
; Copy sprites
        halt
        ld      hl,SPRITES
        ld      de,SPRATR
        ld      bc,4*8
        call    LDIRVM
        jp      LOOP
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
COPY_BLOCK:
;---------------------------------------------------------------------------
; Copy sequentially 8 bytes to VRAM
; Parameters:   DE-destination address
;               HL-source address
;               B -number of blocks to copy
;---------------------------------------------------------------------------
@@LOOP:
        push    bc
        push    hl
        push    de
        ld      bc,8
        call    LDIRVM
        pop     hl
        ld      bc,8
        add     hl,bc
        ex      de,hl
        pop     hl
        pop     bc
        djnz    @@LOOP
        ret
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; DATA
;---------------------------------------------------------------------------
; Font colours
CLR_BLUE:
        db      040h,050h,070h,070h,0f0h,0f0h,0f0h,0f0h

CLR_GREY:
        db      0f0h,0f0h,0f0h,0f0h,0e0h,0e0h,0e0h,0e0h

; Start attributes 
ATR_INITIAL:
        db      0,128,0,8
        db      0,128,4,15
        db      0,0,0,10
        db      0,0,4,15
        db      0,64,0,13
        db      0,64,4,15
        db      0,192,0,7
        db      0,192,4,15

; Texts
TXT_ASMSX:      
        db      "ASMSX V.0.12E: demo i"

TXT_FIXED:       
        db      "fixed point arithmetic"

; Trigonometrical tables
indice=0
SIN_TABLE:
        REPT    64
                db      int(30.0*sin(pi*indice*1.0/32.0))
                indice=indice+1
        ENDR

indice=0
COS_TABLE:
        REPT    64
           db      int(30.0*cos(pi*1.0*indice/32.0))
           indice=indice+1
        ENDR

; Ghost sprite pattern
SPR_GHOST:
        db  000h,003h,00Fh,01Fh,027h,003h,003h,043h,067h,07Fh,07Fh,07Fh,07Fh,06Eh,046h,000h
        db  000h,0C0h,0F0h,0F8h,09Ch,00Ch,00Ch,00Eh,09Eh,0FEh,0FEh,0FEh,0FEh,076h,062h,000h
        db  000h,000h,000h,000h,018h,03Ch,00Ch,00Ch,018h,000h,000h,000h,000h,000h,000h,000h
        db  000h,000h,000h,000h,060h,0F0h,030h,030h,060h,000h,000h,000h,000h,000h,000h,000h

; Text font
FONT:
        db 000h,000h,000h,000h,000h,000h,000h,000h,018h,03Ch,03Ch,03Ch,018h,000h,018h,000h
        db 06Ch,06Ch,048h,000h,000h,000h,000h,000h,06Ch,0FEh,06Ch,06Ch,06Ch,0FEh,06Ch,000h
        db 018h,03Eh,058h,03Ch,01Ah,07Ch,018h,000h,000h,0C6h,0CCh,018h,030h,066h,0C6h,000h
        db 070h,0C8h,0C8h,070h,09Ah,08Ch,076h,000h,018h,018h,010h,000h,000h,000h,000h,000h
        db 00Ch,018h,030h,030h,030h,018h,00Ch,000h,030h,018h,00Ch,00Ch,00Ch,018h,030h,000h
        db 000h,018h,05Ah,03Ch,03Ch,05Ah,018h,000h,000h,018h,018h,07Eh,018h,018h,000h,000h
        db 000h,000h,000h,000h,018h,018h,008h,010h,000h,000h,000h,07Ch,000h,000h,000h,000h
        db 000h,000h,000h,000h,000h,018h,018h,000h,000h,006h,00Ch,018h,030h,060h,0C0h,000h
        db 038h,04Ch,0C6h,0C6h,0C6h,064h,038h,000h,018h,038h,018h,018h,018h,018h,07Eh,000h
        db 07Ch,0C6h,00Eh,03Ch,078h,0E0h,0FEh,000h,07Eh,00Ch,018h,03Ch,006h,0C6h,07Ch,000h
        db 01Ch,03Ch,06Ch,0CCh,0FEh,00Ch,00Ch,000h,0FCh,0C0h,0FCh,006h,006h,0C6h,07Ch,000h
        db 03Ch,060h,0C0h,0FCh,0C6h,0C6h,07Ch,000h,0FEh,0C6h,00Ch,018h,030h,030h,030h,000h
        db 07Ch,0C6h,0C6h,07Ch,0C6h,0C6h,07Ch,000h,07Ch,0C6h,0C6h,07Eh,006h,00Ch,078h,000h
        db 000h,018h,018h,000h,018h,018h,000h,000h,000h,018h,018h,000h,018h,018h,008h,010h
        db 00Ch,018h,030h,060h,030h,018h,00Ch,000h,000h,000h,07Ch,000h,07Ch,000h,000h,000h
        db 060h,030h,018h,00Ch,018h,030h,060h,000h,07Ch,0C6h,006h,01Ch,030h,000h,030h,000h
        db 03Ch,042h,099h,0A1h,0A1h,099h,042h,03Ch,038h,06Ch,0C6h,0C6h,0FEh,0C6h,0C6h,000h
        db 0FCh,0C6h,0C6h,0FCh,0C6h,0C6h,0FCh,000h,03Ch,066h,0C0h,0C0h,0C0h,066h,03Ch,000h
        db 0F8h,0CCh,0C6h,0C6h,0C6h,0CCh,0F8h,000h,0FEh,0C0h,0C0h,0F8h,0C0h,0C0h,0FEh,000h
        db 0FEh,0C0h,0C0h,0F8h,0C0h,0C0h,0C0h,000h,03Eh,060h,0C0h,0CEh,0C6h,066h,03Eh,000h
        db 0C6h,0C6h,0C6h,0FEh,0C6h,0C6h,0C6h,000h,07Eh,018h,018h,018h,018h,018h,07Eh,000h
        db 006h,006h,006h,006h,006h,0C6h,07Ch,000h,0C6h,0CCh,0D8h,0F0h,0F8h,0DCh,0CEh,000h
        db 0C0h,0C0h,0C0h,0C0h,0C0h,0C0h,0FEh,000h,0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,000h
        db 0C6h,0E6h,0F6h,0FEh,0DEh,0CEh,0C6h,000h,07Ch,0C6h,0C6h,0C6h,0C6h,0C6h,07Ch,000h
        db 0FCh,0C6h,0C6h,0C6h,0FCh,0C0h,0C0h,000h,07Ch,0C6h,0C6h,0C6h,0DEh,0CCh,076h,000h
        db 0FCh,0C6h,0C6h,0CEh,0F8h,0DCh,0CEh,000h,078h,0CCh,0C0h,07Ch,006h,0C6h,07Ch,000h
        db 07Eh,018h,018h,018h,018h,018h,018h,000h,0C6h,0C6h,0C6h,0C6h,0C6h,0C6h,07Ch,000h
        db 0C6h,0C6h,0C6h,0EEh,07Ch,038h,010h,000h,0C6h,0C6h,0D6h,0FEh,0FEh,06Ch,044h,000h
        db 0C6h,0EEh,07Ch,038h,07Ch,0EEh,0C6h,000h,066h,066h,066h,03Ch,018h,018h,018h,000h
        db 0FEh,00Eh,01Ch,038h,070h,0E0h,0FEh,000h,0F8h,0C0h,0C0h,0C0h,0C0h,0C0h,0F8h,000h
        db 000h,080h,040h,020h,010h,008h,000h,000h,0F8h,018h,018h,018h,018h,018h,0F8h,000h
        db 000h,000h,020h,050h,088h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0F8h 
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; VARIABLES
;---------------------------------------------------------------------------
        .page   3
POSITION:
        ds      2
SPEED:
        ds      2
ACCELERATION:
        ds      2
HORIZONTAL:
        ds      1
SPRITES:
        ds      4*8
;---------------------------------------------------------------------------


